library(ggplot2)
#library(gridExtra)
ls=0.8

fuckit<-c("#e41a1c","#377eb8","#4daf4a")
fuckit2<-c("black","red","#4daf4a")
cbbPalette <- fuckit2
theme_set(theme_bw())

#em<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-11-truncations/data/gsnap-raw/enrichment/joint-hotcold.txt")
#em<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-11-truncations/data/gsnap-raw/enrichment-inverse/joint-hotcold.txt")
#em<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-11-truncations/data/gsnap-raw/enrichment-inverse/joint-algo2.txt")
em<-read.table("/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-11-truncations/data/gsnap-raw/enrichment-avfreq/joint.enrichment.txt")
names(em)<-c("condition","pos","cov","wcov","enrichment")
em$condition <- factor(em$condition, levels=c("hot","cold"))

#g<-ggplot(em,aes(x=pos))+geom_line(size=ls,aes(y=cov,colour="unweighted"))+geom_line(size=ls,aes(y=wcov,colour="weighted"))+
#  theme(legend.position=c(0.9,0.7),axis.title.x=element_blank(),axis.text.x=element_blank())+
#  scale_colour_manual(values=cbbPalette)+labs(fill="Cond.")+ylab("scaled coverage")

# necessary 
# 1 - 136
# 2763 - 2907
ymax=max(em$enrichment)
p<-ggplot(em,aes(x=pos,y=enrichment))+geom_line(size=ls)+theme(legend.position="none")+
  xlab("Position in P-element")+ylab("average pop.freq")+facet_grid(.~condition,scales="free_x", space = "free_x")+scale_y_log10()+
  annotate("rect",xmin=1,xmax=136,ymin=0,ymax=ymax,alpha=0.3,fill="green")+annotate("rect",xmin=2763,xmax=2907,ymin=0,ymax=ymax,alpha=0.3,fill="green")
pdf(file="/Users/robertkofler/analysis/ee-dsim-pele/analysis/2016-11-truncations/graphs/enrichment-avfreq.pdf",width=7,height=3.3)

plot(p)
#grid.arrange(g,o,ncol=1,nrow=2,widths=c(1),heights=c(1,2))
dev.off()
#dev.copy2eps(file="/Volumes/Volume_4/analysis/ee-dsim-pele/analysis/2016-06-truncations/graphs/truncation-enrichment-avfreq-notlog.eps")




